//+------------------------------------------------------------------+
//|                                                         OsMA.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2004, MetaQuotes Software Corp."
#property  link      "http://www.metaquotes.net/"
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 4
#property  indicator_color1  LimeGreen
#property  indicator_color2  Green
#property  indicator_color3  Red
#property  indicator_color4  Maroon

//#property  indicator_level1  0.0003
//#property  indicator_level2  -0.0003

//---- indicator buffers
extern int FastEMA=12;
extern int SlowEMA=26;
extern int SignalSMA=9;

double     ind_buffer1[], ind_buffer1s[];
double     ind_buffer2[], ind_buffer2s[];
double     ind_buffer3[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- 1 additional buffer used for counting.
   IndicatorBuffers(5);
   //---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,4);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,4);
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,4);
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID,4);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+1);
   SetIndexDrawBegin(0,34);
   SetIndexDrawBegin(1,34);
   SetIndexDrawBegin(3,34);
   SetIndexDrawBegin(4,34);
//---- 3 indicator buffers mapping
   if(!SetIndexBuffer(0,ind_buffer1) &&
      !SetIndexBuffer(1,ind_buffer1s) &&
      !SetIndexBuffer(2,ind_buffer2) &&
      !SetIndexBuffer(3,ind_buffer2s) &&
      !SetIndexBuffer(4,ind_buffer3))
      Print("cannot set indicator buffers!");
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("OsMA("+FastEMA+","+SlowEMA+","+SignalSMA+")");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Awesome Oscillator                                               |
//+------------------------------------------------------------------+
int start()
  {
   int    limit;
   int    counted_bars=IndicatorCounted();
   double prev,current;
//---- check for possible errors
   if(counted_bars<0) return(-1);
   //---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- macd counted in the 1-st additional buffer
   for(int i=0; i<limit; i++)
      ind_buffer3[i]=iOsMA(NULL,0,FastEMA,SlowEMA,SignalSMA,PRICE_WEIGHTED,i);
//---- dispatch values between 2 buffers
   bool up=true;
   for(i=limit-1; i>=0; i--)
     {
      current=ind_buffer3[i];
      prev=ind_buffer3[i+1];
      if (((current<0)&&(prev>0))||(current<0))   up= false;    
      if (((current>0)&&(prev<0))||(current>0))   up= true;      
      
      if(!up)
        {
         if(current > prev)
           {
            ind_buffer2s[i]=current;
            ind_buffer2[i]=0.0;
            ind_buffer1[i]=0.0;
            ind_buffer1s[i]=0.0;             
           }        
         else
           {
            ind_buffer2[i]=current;
            ind_buffer2s[i]=0.0;
            ind_buffer1[i]=0.0;
            ind_buffer1s[i]=0.0;            
           }             
        }
        else
        {
         if(current < prev)
           {
            ind_buffer1s[i]=current;
            ind_buffer1[i]=0.0;
            ind_buffer2[i]=0.0;
            ind_buffer2s[i]=0.0;
           }
        else
           {
            ind_buffer1[i]=current;
            ind_buffer1s[i]=0.0;
            ind_buffer2[i]=0.0;
            ind_buffer2s[i]=0.0;
            }           
         }       
     }
//---- done
   return(0);
  }

